"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadController = void 0;
const youtube_dl_exec_1 = __importDefault(require("youtube-dl-exec"));
const fluent_ffmpeg_1 = __importDefault(require("fluent-ffmpeg"));
const ffmpeg_1 = __importDefault(require("@ffmpeg-installer/ffmpeg"));
const stream_1 = require("stream");
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
fluent_ffmpeg_1.default.setFfmpegPath(ffmpeg_1.default.path);
class DownloadController {
    downloadMp3(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            const videoUrl = req.query.url;
            if (!videoUrl) {
                return res
                    .status(400)
                    .json({ success: false, message: "No URL provided" });
            }
            try {
                const info = yield (0, youtube_dl_exec_1.default)(videoUrl, {
                    dumpSingleJson: true,
                    noCheckCertificates: true,
                    noWarnings: true,
                    preferFreeFormats: true,
                    youtubeSkipDashManifest: true,
                });
                console.log("Video Info:", info); // Log the info object to inspect its structure
                // Extract the title from the info object
                let title = info.title || "video";
                // Sanitize the title to remove invalid characters
                title = title.replace(/[^a-zA-Z0-9 \-_]/g, "");
                const outputPath = path_1.default.resolve(__dirname, `${title}.mp3`);
                console.log("Output Path:", outputPath); // Log the output path
                // Set headers
                res.setHeader("Content-Disposition", `attachment; filename="${title}.mp3"`);
                res.setHeader("Content-Type", "audio/mpeg");
                console.log("Content-Disposition Header:", `attachment; filename="${title}.mp3"`); // Log the header
                const stream = new stream_1.PassThrough();
                const downloadProcess = youtube_dl_exec_1.default.exec(videoUrl, {
                    format: "bestaudio",
                    noCheckCertificates: true,
                    noWarnings: true,
                    preferFreeFormats: true,
                    youtubeSkipDashManifest: true,
                    output: "-",
                });
                if (downloadProcess.stdout) {
                    downloadProcess.stdout.pipe(stream);
                }
                else {
                    throw new Error("Failed to start download process");
                }
                (0, fluent_ffmpeg_1.default)(stream)
                    .audioBitrate(128)
                    .save(outputPath)
                    .on("end", () => {
                    res.download(outputPath, `${title}.mp3`, (err) => {
                        if (err) {
                            console.error("Error sending file:", err);
                        }
                        fs_1.default.unlinkSync(outputPath); // Delete the file after sending it
                    });
                });
            }
            catch (error) {
                console.error("Error in downloadMp3:", error);
                res
                    .status(500)
                    .json({
                    success: false,
                    message: "Failed to download video",
                    error: error.message,
                });
            }
        });
    }
}
exports.DownloadController = DownloadController;
