"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const index_1 = require("./routes/index");
const app = (0, express_1.default)();
const PORT = process.env.PORT || 3000;
// app.use(cors({ exposedHeaders: ["Content-Disposition"] }));
// origin: "http://localhost:3001",
// Custom CORS configuration to allow any subdomain of meminozdogan.com
const corsOptions = {
    // origin: (origin: string | undefined, callback: (err: Error | null, allow?: boolean) => void) => {
    //   if (origin && (origin === 'https://meminozdogan.com' || origin.endsWith('.meminozdogan.com'))) {
    //     callback(null, true);
    //   } else {
    //     callback(new Error('Not allowed by CORS'));
    //   }
    // },
    origin: '*',
    methods: 'GET,POST',
    exposedHeaders: ['Content-Disposition'],
    allowedHeaders: 'Content-Type,Authorization'
};
app.use((0, cors_1.default)(corsOptions));
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
// Test route to verify CORS
app.get("/test", (req, res) => {
    res.json({ message: "CORS is working!" });
});
(0, index_1.setRoutes)(app);
app.listen(PORT, () => {
    console.log(`Server is running on http://localhost:${PORT}`);
});
